<?php
/*
Template Name: Landing Page
*/
$hudson_edge_options = hudson_edge_return_global_options();
$hudson_edge_id = hudson_edge_get_page_id();
$hudson_edge_sidebar = hudson_edge_get_sidebar_layout();

$hudson_edge_enable_page_comments = false;
if(get_post_meta($hudson_edge_id, "edgt_enable-page-comments", true) == 'yes') {
	$hudson_edge_enable_page_comments = true;
}

if(get_post_meta($hudson_edge_id, "edgt_page_background_color", true) != ""){
	$hudson_edge_background_color = 'background-color: '.esc_attr(get_post_meta($hudson_edge_id, "edgt_page_background_color", true));
}else{
	$hudson_edge_background_color = "";
}

$hudson_edge_pagination_classes = '';
if( isset($hudson_edge_options['pagination_type']) && $hudson_edge_options['pagination_type'] == 'standard' ) {
	if( isset($hudson_edge_options['pagination_standard_position']) && $hudson_edge_options['pagination_standard_position'] !== '' ) {
		$hudson_edge_pagination_classes .= "standard_".esc_attr($hudson_edge_options['pagination_standard_position']);
	}
}
elseif ( isset($hudson_edge_options['pagination_type']) && $hudson_edge_options['pagination_type'] == 'arrows_on_sides' ) {
	$hudson_edge_pagination_classes .= "arrows_on_sides";
}

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />

        <?php
        /**
         * edgt_header_meta hook
         *
         * @see edgt_header_meta() - hooked with 10
         * @see edgt_user_scalable_meta() - hooked with 10
         */
        do_action('edgt_header_meta');
        ?>

        <?php wp_head(); ?>

    </head>

<body <?php body_class(); ?>>

<div class="wrapper">
    <div class="wrapper_inner">
        <div class="content content_top_margin_none">
            <div class="content_inner">
                <?php get_template_part( 'title' ); ?>
                <?php get_template_part('slider');?>
                <div class="full_width" <?php hudson_edge_inline_style($hudson_edge_background_color); ?>>
                    <div class="full_width_inner">
                        <?php if(($hudson_edge_sidebar == "default")||($hudson_edge_sidebar == "")) : ?>
                            <?php if (have_posts()) :
                                while (have_posts()) : the_post(); ?>
                                    <?php the_content(); ?>
                                    <?php
                                    $hudson_edge_args_pages = array(
                                        'before'           => '<div class="single_links_pages ' .$hudson_edge_pagination_classes. '"><div class="single_links_pages_inner">',
                                        'after'            => '</p>',
                                        'pagelink'         => '<span>%</span>'
                                    );

                                    wp_link_pages($hudson_edge_args_pages); ?>
                                    <?php
                                    if($hudson_edge_enable_page_comments){
                                        ?>
                                        <div class="container">
                                            <div class="container_inner">
                                                <?php
                                                comments_template('', true);
                                                ?>
                                            </div>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                <?php endwhile; ?>
                            <?php endif; ?>
                        <?php elseif($hudson_edge_sidebar == "1" || $hudson_edge_sidebar == "2"): ?>

                        <?php if($hudson_edge_sidebar == "1") : ?>
                        <div class="two_columns_66_33 clearfix grid2">
                            <div class="column1">
                        <?php elseif($hudson_edge_sidebar == "2") : ?>
                        <div class="two_columns_75_25 clearfix grid2">
                            <div class="column1">
                                <?php endif; ?>
                                <?php if (have_posts()) :
                                    while (have_posts()) : the_post(); ?>
                                        <div class="column_inner">

                                            <?php the_content(); ?>
                                            <?php
                                            $hudson_edge_args_pages = array(
                                                'before'           => '<div class="single_links_pages ' .$hudson_edge_pagination_classes. '"><div class="single_links_pages_inner">',
                                                'after'            => '</p>',
                                                'pagelink'         => '<span>%</span>'
                                            );

                                            wp_link_pages($hudson_edge_args_pages); ?>
                                            <?php
                                            if($hudson_edge_enable_page_comments){
                                                ?>
                                                <div class="container">
                                                    <div class="container_inner">
                                                        <?php
                                                        comments_template('', true);
                                                        ?>
                                                    </div>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    <?php endwhile; ?>
                                <?php endif; ?>


                            </div>
                            <div class="column2"><?php get_sidebar();?></div>
                        </div>
                        <?php elseif($hudson_edge_sidebar == "3" || $hudson_edge_sidebar == "4"): ?>
                        <?php if($hudson_edge_sidebar == "3") : ?>
                        <div class="two_columns_33_66 clearfix grid2">
                            <div class="column1"><?php get_sidebar();?></div>
                            <div class="column2">
                                <?php elseif($hudson_edge_sidebar == "4") : ?>
                                <div class="two_columns_25_75 clearfix grid2">
                                    <div class="column1"><?php get_sidebar();?></div>
                                    <div class="column2">
                                        <?php endif; ?>
                                        <?php if (have_posts()) :
                                            while (have_posts()) : the_post(); ?>
                                                <div class="column_inner">
                                                    <?php the_content(); ?>
                                                    <?php
                                                    $hudson_edge_args_pages = array(
                                                        'before'           => '<div class="single_links_pages ' .$hudson_edge_pagination_classes. '"><div class="single_links_pages_inner">',
                                                        'after'            => '</p>',
                                                        'pagelink'         => '<span>%</span>'
                                                    );

                                                    wp_link_pages($hudson_edge_args_pages); ?>
                                                    <?php
                                                    if($hudson_edge_enable_page_comments){
                                                        ?>
                                                        <div class="container">
                                                            <div class="container_inner">
                                                                <?php
                                                                comments_template('', true);
                                                                ?>
                                                            </div>
                                                        </div>
                                                    <?php
                                                    }
                                                    ?>
                                                </div>
                                            <?php endwhile; ?>
                                        <?php endif; ?>


                                    </div>

                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
            </div>
        </div>
    </div>
</div>
<?php wp_footer(); ?>
</body>
</html>